/*
 * Decompiled with CFR 0.152.
 */
package com.djinfinite.manors_bounty.items;

import com.djinfinite.manors_bounty.items.FoodEffect;
import com.djinfinite.manors_bounty.items.FoodEffectType;
import com.djinfinite.manors_bounty.items.FoodType;
import com.djinfinite.manors_bounty.items.ICooldownItem;
import com.djinfinite.manors_bounty.registries.ModItems;
import com.djinfinite.manors_bounty.registries.ModMobEffects;
import com.djinfinite.manors_bounty.utils.CapabilityUtils;
import com.djinfinite.manors_bounty.utils.data_struct.Quad;
import com.djinfinite.manors_bounty.utils.data_struct.Quintuple;
import com.djinfinite.manors_bounty.utils.data_struct.Sextuplet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public interface IFoodItem
extends ICooldownItem {
    public FoodEffectType getFoodEffectType();

    public FoodType getFoodType();

    public FoodEffect getFoodEffect();

    @Override
    default public ItemStack usedWhenNotInCooldown(Level level, Player player, ItemStack itemStack) {
        if (this.getFoodEffect().apply((LivingEntity)player)) {
            this.cooldown(player, itemStack.m_41720_());
        }
        return ICooldownItem.super.usedWhenNotInCooldown(level, player, itemStack);
    }

    @Override
    default public int cooldownTime() {
        return this.getFoodEffectType().cooldownTime;
    }

    default public ItemStack returnItem(Player player, ItemStack itemStack, ItemStack toReturn) {
        if (player == null || !player.m_150110_().f_35937_) {
            if (itemStack.m_41619_()) {
                return toReturn;
            }
            if (player != null) {
                player.m_150109_().m_36054_(toReturn);
            }
        }
        return itemStack;
    }

    default public ItemStack returnCup(Player player, ItemStack itemStack) {
        return this.returnItem(player, itemStack, new ItemStack((ItemLike)ModItems.DEFORMED_GLASS_BOTTLE.get()));
    }

    default public List<Component> tooltips(ItemStack itemStack) {
        ArrayList<Component> components = new ArrayList<Component>();
        Item item = itemStack.m_41720_();
        if (item instanceof IFoodItem) {
            IFoodItem iFoodItem = (IFoodItem)item;
            if (Screen.m_96638_()) {
                switch (iFoodItem.getFoodEffectType()) {
                    case A: {
                        HashMap<Pair, ArrayList> lines = new HashMap<Pair, ArrayList>();
                        ((FoodEffect.A)iFoodItem.getFoodEffect()).mobEffects().forEach(sextuplet -> {
                            MobEffect mobEffect = (MobEffect)sextuplet.getLeft();
                            double chance = (Double)sextuplet.getMiddle();
                            int addLevel = (Integer)sextuplet.getRight();
                            Pair key = Pair.of((Object)chance, (Object)addLevel);
                            if (lines.containsKey(key)) {
                                ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                            } else {
                                lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                            }
                        });
                        ArrayList<Triple> list = new ArrayList<Triple>();
                        lines.forEach((quintuple, componentArrayList) -> {
                            double chance = (Double)quintuple.getLeft();
                            int addLevel = (Integer)quintuple.getRight();
                            MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0])).m_130940_(ChatFormatting.BLUE);
                            for (int i = 0; i < componentArrayList.size(); ++i) {
                                mutableComponent.m_7220_((Component)componentArrayList.get(i));
                                if (i >= componentArrayList.size() - 1) continue;
                                mutableComponent.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.BLUE));
                            }
                            mutableComponent.m_130940_(ChatFormatting.BLUE);
                            list.add(Triple.of((Object)mutableComponent, (Object)chance, (Object)addLevel));
                        });
                        list.forEach(triple -> components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_raw_give", (Object[])new Object[]{triple.getLeft(), triple.getMiddle(), triple.getRight()}).m_130940_(ChatFormatting.BLUE)));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"IV"}).m_130940_(ChatFormatting.RED));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                        break;
                    }
                    case B: {
                        HashMap<Quintuple, ArrayList> lines = new HashMap<Quintuple, ArrayList>();
                        ((FoodEffect.B)iFoodItem.getFoodEffect()).mobEffects().forEach(sextuplet -> {
                            MobEffect mobEffect = (MobEffect)sextuplet.getFirst();
                            double firstChance = (Double)sextuplet.getSecond();
                            int firstAddTime = (Integer)sextuplet.getThird();
                            int addLevel = (Integer)sextuplet.getFourth();
                            int secondAddTime = (Integer)sextuplet.getFifth();
                            int newTime = (Integer)sextuplet.getSixth();
                            Quintuple<Double, Integer, Integer, Integer, Integer> key = Quintuple.of(firstChance, firstAddTime, addLevel, secondAddTime, newTime);
                            if (lines.containsKey(key)) {
                                ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                            } else {
                                lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                            }
                        });
                        ArrayList<Sextuplet> list = new ArrayList<Sextuplet>();
                        lines.forEach((quintuple, componentArrayList) -> {
                            double firstChance = (Double)quintuple.getFirst();
                            int firstAddTime = (Integer)quintuple.getSecond();
                            int addLevel = (Integer)quintuple.getThird();
                            int secondAddTime = (Integer)quintuple.getFourth();
                            int newTime = (Integer)quintuple.getFifth();
                            MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0])).m_130940_(ChatFormatting.BLUE);
                            for (int i = 0; i < componentArrayList.size(); ++i) {
                                mutableComponent.m_7220_((Component)componentArrayList.get(i));
                                if (i >= componentArrayList.size() - 1) continue;
                                mutableComponent.m_7220_((Component)Component.m_237113_((String)"/"));
                            }
                            mutableComponent.m_130940_(ChatFormatting.BLUE);
                            list.add(Sextuplet.of(mutableComponent, firstChance, firstAddTime, addLevel, secondAddTime, newTime));
                        });
                        list.forEach(sextuplet -> {
                            double firstChance = (Double)sextuplet.getSecond();
                            int firstAddTime = (Integer)sextuplet.getThird();
                            int addLevel = (Integer)sextuplet.getFourth();
                            int secondAddTime = (Integer)sextuplet.getFifth();
                            int newTime = (Integer)sextuplet.getSixth();
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_1", (Object[])new Object[]{firstChance, sextuplet.getFirst(), firstAddTime / 20}).m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237115_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_2").m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_3", (Object[])new Object[]{100.0 - firstChance, addLevel, sextuplet.getFirst()}).m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_4", (Object[])new Object[]{secondAddTime / 20, newTime / 20}).m_130940_(ChatFormatting.BLUE));
                        });
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"VI"}).m_130940_(ChatFormatting.RED));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                        break;
                    }
                    case C: {
                        HashMap<Quad, ArrayList> lines = new HashMap<Quad, ArrayList>();
                        ((FoodEffect.C)iFoodItem.getFoodEffect()).mobEffects().forEach(sextuplet -> {
                            MobEffect mobEffect = (MobEffect)sextuplet.getFirst();
                            double firstChance = (Double)sextuplet.getSecond();
                            double secondChance = (Double)sextuplet.getThird();
                            int addLevel = (Integer)sextuplet.getFourth();
                            int newTime = (Integer)sextuplet.getFifth();
                            Quad<Double, Double, Integer, Integer> key = Quad.of(firstChance, secondChance, addLevel, newTime);
                            if (lines.containsKey(key)) {
                                ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                            } else {
                                lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                            }
                        });
                        ArrayList<Quintuple> list = new ArrayList<Quintuple>();
                        lines.forEach((quad, componentArrayList) -> {
                            double firstChance = (Double)quad.getValue1();
                            double secondChance = (Double)quad.getValue2();
                            int addLevel = (Integer)quad.getValue3();
                            int newTime = (Integer)quad.getValue4();
                            MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0]));
                            for (int i = 0; i < componentArrayList.size(); ++i) {
                                mutableComponent.m_7220_((Component)componentArrayList.get(i));
                                if (i >= componentArrayList.size() - 1) continue;
                                mutableComponent.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.BLUE));
                            }
                            mutableComponent.m_130940_(ChatFormatting.BLUE);
                            list.add(Quintuple.of(mutableComponent, firstChance, secondChance, addLevel, newTime));
                        });
                        list.forEach(quintuple -> {
                            double firstChance = (Double)quintuple.getSecond();
                            double secondChance = (Double)quintuple.getThird();
                            int addLevel = (Integer)quintuple.getFourth();
                            int newTime = (Integer)quintuple.getFifth();
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_1", (Object[])new Object[]{String.valueOf(firstChance), addLevel, quintuple.getFirst()}).m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_2", (Object[])new Object[]{secondChance, addLevel, quintuple.getFirst()}).m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_3", (Object[])new Object[]{newTime / 20}).m_130940_(ChatFormatting.BLUE));
                        });
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"VIII"}).m_130940_(ChatFormatting.RED));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                        break;
                    }
                    case XB: {
                        HashMap<Quintuple, ArrayList> lines = new HashMap<Quintuple, ArrayList>();
                        FoodEffect.X.XB x = (FoodEffect.X.XB)iFoodItem.getFoodEffect();
                        x.b().mobEffects().forEach(sextuplet -> {
                            MobEffect mobEffect = (MobEffect)sextuplet.getFirst();
                            double firstChance = (Double)sextuplet.getSecond();
                            int firstAddTime = (Integer)sextuplet.getThird();
                            int addLevel = (Integer)sextuplet.getFourth();
                            int secondAddTime = (Integer)sextuplet.getFifth();
                            int newTime = (Integer)sextuplet.getSixth();
                            Quintuple<Double, Integer, Integer, Integer, Integer> key = Quintuple.of(firstChance, firstAddTime, addLevel, secondAddTime, newTime);
                            if (lines.containsKey(key)) {
                                ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                            } else {
                                lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                            }
                        });
                        ArrayList<Sextuplet> list = new ArrayList<Sextuplet>();
                        lines.forEach((quintuple, componentArrayList) -> {
                            double firstChance = (Double)quintuple.getFirst();
                            int firstAddTime = (Integer)quintuple.getSecond();
                            int addLevel = (Integer)quintuple.getThird();
                            int secondAddTime = (Integer)quintuple.getFourth();
                            int newTime = (Integer)quintuple.getFifth();
                            MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0])).m_130940_(ChatFormatting.BLUE);
                            for (int i = 0; i < componentArrayList.size(); ++i) {
                                mutableComponent.m_7220_((Component)componentArrayList.get(i));
                                if (i >= componentArrayList.size() - 1) continue;
                                mutableComponent.m_7220_((Component)Component.m_237113_((String)"/"));
                            }
                            mutableComponent.m_130940_(ChatFormatting.BLUE);
                            list.add(Sextuplet.of(mutableComponent, firstChance, firstAddTime, addLevel, secondAddTime, newTime));
                        });
                        components.addAll(x.tooltip);
                        list.forEach(sextuplet -> {
                            double firstChance = (Double)sextuplet.getSecond();
                            int firstAddTime = (Integer)sextuplet.getThird();
                            int addLevel = (Integer)sextuplet.getFourth();
                            int secondAddTime = (Integer)sextuplet.getFifth();
                            int newTime = (Integer)sextuplet.getSixth();
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_1", (Object[])new Object[]{firstChance, sextuplet.getFirst(), firstAddTime / 20}).m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237115_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_2").m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_3", (Object[])new Object[]{100.0 - firstChance, addLevel, sextuplet.getFirst()}).m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_4", (Object[])new Object[]{secondAddTime / 20, newTime / 20}).m_130940_(ChatFormatting.BLUE));
                        });
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"IV"}).m_130940_(ChatFormatting.RED));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                        break;
                    }
                    case XC: {
                        FoodEffect.X.XC x = (FoodEffect.X.XC)iFoodItem.getFoodEffect();
                        HashMap<Quad, ArrayList> lines = new HashMap<Quad, ArrayList>();
                        x.c().mobEffects().forEach(sextuplet -> {
                            MobEffect mobEffect = (MobEffect)sextuplet.getFirst();
                            double firstChance = (Double)sextuplet.getSecond();
                            double secondChance = (Double)sextuplet.getThird();
                            int addLevel = (Integer)sextuplet.getFourth();
                            int newTime = (Integer)sextuplet.getFifth();
                            Quad<Double, Double, Integer, Integer> key = Quad.of(firstChance, secondChance, addLevel, newTime);
                            if (lines.containsKey(key)) {
                                ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                            } else {
                                lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                            }
                        });
                        ArrayList<Quintuple> list = new ArrayList<Quintuple>();
                        lines.forEach((quad, componentArrayList) -> {
                            double firstChance = (Double)quad.getValue1();
                            double secondChance = (Double)quad.getValue2();
                            int addLevel = (Integer)quad.getValue3();
                            int newTime = (Integer)quad.getValue4();
                            MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0]));
                            for (int i = 0; i < componentArrayList.size(); ++i) {
                                mutableComponent.m_7220_((Component)componentArrayList.get(i));
                                if (i >= componentArrayList.size() - 1) continue;
                                mutableComponent.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.BLUE));
                            }
                            mutableComponent.m_130940_(ChatFormatting.BLUE);
                            list.add(Quintuple.of(mutableComponent, firstChance, secondChance, addLevel, newTime));
                        });
                        list.forEach(sextuplet -> {
                            double firstChance = (Double)sextuplet.getSecond();
                            double secondChance = (Double)sextuplet.getThird();
                            int addLevel = (Integer)sextuplet.getFourth();
                            int newTime = (Integer)sextuplet.getFifth();
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_1", (Object[])new Object[]{firstChance, addLevel, sextuplet.getFirst()}).m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_2", (Object[])new Object[]{secondChance, addLevel, sextuplet.getFirst()}).m_130940_(ChatFormatting.BLUE));
                            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_3", (Object[])new Object[]{newTime / 20}).m_130940_(ChatFormatting.BLUE));
                        });
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"VIII"}).m_130940_(ChatFormatting.RED));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                    }
                }
            } else {
                components.add((Component)Component.m_237115_((String)"tips.manors_bounty.fruit_effect_shift_check").m_130940_(ChatFormatting.BLUE));
            }
            if (CapabilityUtils.isInLocalModCooldown(item)) {
                components.add((Component)Component.m_237115_((String)"tips.manors_bounty.fruit_effect_cooldown_0").m_130940_(ChatFormatting.RED));
                components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_get", (Object[])new Object[]{CapabilityUtils.getLocalModCooldown(item) / 20}).m_130940_(ChatFormatting.BLUE));
            }
        }
        return components;
    }

    default public List<Component> tooltips(IFoodItem iFoodItem, ItemStack itemStack) {
        ArrayList<Component> components = new ArrayList<Component>();
        Item item = itemStack.m_41720_();
        if (Screen.m_96638_()) {
            switch (iFoodItem.getFoodEffectType()) {
                case A: {
                    HashMap<Pair, ArrayList> lines = new HashMap<Pair, ArrayList>();
                    ((FoodEffect.A)iFoodItem.getFoodEffect()).mobEffects().forEach(sextuplet -> {
                        MobEffect mobEffect = (MobEffect)sextuplet.getLeft();
                        double chance = (Double)sextuplet.getMiddle();
                        int addLevel = (Integer)sextuplet.getRight();
                        Pair key = Pair.of((Object)chance, (Object)addLevel);
                        if (lines.containsKey(key)) {
                            ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                        } else {
                            lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                        }
                    });
                    ArrayList<Triple> list = new ArrayList<Triple>();
                    lines.forEach((quintuple, componentArrayList) -> {
                        double chance = (Double)quintuple.getLeft();
                        int addLevel = (Integer)quintuple.getRight();
                        MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0])).m_130940_(ChatFormatting.BLUE);
                        for (int i = 0; i < componentArrayList.size(); ++i) {
                            mutableComponent.m_7220_((Component)componentArrayList.get(i));
                            if (i >= componentArrayList.size() - 1) continue;
                            mutableComponent.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.BLUE));
                        }
                        mutableComponent.m_130940_(ChatFormatting.BLUE);
                        list.add(Triple.of((Object)mutableComponent, (Object)chance, (Object)addLevel));
                    });
                    list.forEach(triple -> components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_raw_give", (Object[])new Object[]{triple.getLeft(), triple.getMiddle(), triple.getRight()}).m_130940_(ChatFormatting.BLUE)));
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"IV"}).m_130940_(ChatFormatting.RED));
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case B: {
                    HashMap<Quintuple, ArrayList> lines = new HashMap<Quintuple, ArrayList>();
                    ((FoodEffect.B)iFoodItem.getFoodEffect()).mobEffects().forEach(sextuplet -> {
                        MobEffect mobEffect = (MobEffect)sextuplet.getFirst();
                        double firstChance = (Double)sextuplet.getSecond();
                        int firstAddTime = (Integer)sextuplet.getThird();
                        int addLevel = (Integer)sextuplet.getFourth();
                        int secondAddTime = (Integer)sextuplet.getFifth();
                        int newTime = (Integer)sextuplet.getSixth();
                        Quintuple<Double, Integer, Integer, Integer, Integer> key = Quintuple.of(firstChance, firstAddTime, addLevel, secondAddTime, newTime);
                        if (lines.containsKey(key)) {
                            ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                        } else {
                            lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                        }
                    });
                    ArrayList<Sextuplet> list = new ArrayList<Sextuplet>();
                    lines.forEach((quintuple, componentArrayList) -> {
                        double firstChance = (Double)quintuple.getFirst();
                        int firstAddTime = (Integer)quintuple.getSecond();
                        int addLevel = (Integer)quintuple.getThird();
                        int secondAddTime = (Integer)quintuple.getFourth();
                        int newTime = (Integer)quintuple.getFifth();
                        MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0])).m_130940_(ChatFormatting.BLUE);
                        for (int i = 0; i < componentArrayList.size(); ++i) {
                            mutableComponent.m_7220_((Component)componentArrayList.get(i));
                            if (i >= componentArrayList.size() - 1) continue;
                            mutableComponent.m_7220_((Component)Component.m_237113_((String)"/"));
                        }
                        mutableComponent.m_130940_(ChatFormatting.BLUE);
                        list.add(Sextuplet.of(mutableComponent, firstChance, firstAddTime, addLevel, secondAddTime, newTime));
                    });
                    list.forEach(sextuplet -> {
                        double firstChance = (Double)sextuplet.getSecond();
                        int firstAddTime = (Integer)sextuplet.getThird();
                        int addLevel = (Integer)sextuplet.getFourth();
                        int secondAddTime = (Integer)sextuplet.getFifth();
                        int newTime = (Integer)sextuplet.getSixth();
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_1", (Object[])new Object[]{firstChance, sextuplet.getFirst(), firstAddTime / 20}).m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237115_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_2").m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_3", (Object[])new Object[]{100.0 - firstChance, addLevel, sextuplet.getFirst()}).m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_4", (Object[])new Object[]{secondAddTime / 20, newTime / 20}).m_130940_(ChatFormatting.BLUE));
                    });
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"VI"}).m_130940_(ChatFormatting.RED));
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case C: {
                    HashMap<Quad, ArrayList> lines = new HashMap<Quad, ArrayList>();
                    ((FoodEffect.C)iFoodItem.getFoodEffect()).mobEffects().forEach(sextuplet -> {
                        MobEffect mobEffect = (MobEffect)sextuplet.getFirst();
                        double firstChance = (Double)sextuplet.getSecond();
                        double secondChance = (Double)sextuplet.getThird();
                        int addLevel = (Integer)sextuplet.getFourth();
                        int newTime = (Integer)sextuplet.getFifth();
                        Quad<Double, Double, Integer, Integer> key = Quad.of(firstChance, secondChance, addLevel, newTime);
                        if (lines.containsKey(key)) {
                            ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                        } else {
                            lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                        }
                    });
                    ArrayList<Quintuple> list = new ArrayList<Quintuple>();
                    lines.forEach((quad, componentArrayList) -> {
                        double firstChance = (Double)quad.getValue1();
                        double secondChance = (Double)quad.getValue2();
                        int addLevel = (Integer)quad.getValue3();
                        int newTime = (Integer)quad.getValue4();
                        MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0]));
                        for (int i = 0; i < componentArrayList.size(); ++i) {
                            mutableComponent.m_7220_((Component)componentArrayList.get(i));
                            if (i >= componentArrayList.size() - 1) continue;
                            mutableComponent.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.BLUE));
                        }
                        mutableComponent.m_130940_(ChatFormatting.BLUE);
                        list.add(Quintuple.of(mutableComponent, firstChance, secondChance, addLevel, newTime));
                    });
                    list.forEach(quintuple -> {
                        double firstChance = (Double)quintuple.getSecond();
                        double secondChance = (Double)quintuple.getThird();
                        int addLevel = (Integer)quintuple.getFourth();
                        int newTime = (Integer)quintuple.getFifth();
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_1", (Object[])new Object[]{String.valueOf(firstChance), addLevel, quintuple.getFirst()}).m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_2", (Object[])new Object[]{secondChance, addLevel, quintuple.getFirst()}).m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_3", (Object[])new Object[]{newTime / 20}).m_130940_(ChatFormatting.BLUE));
                    });
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"VIII"}).m_130940_(ChatFormatting.RED));
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case XB: {
                    HashMap<Quintuple, ArrayList> lines = new HashMap<Quintuple, ArrayList>();
                    FoodEffect.X.XB x = (FoodEffect.X.XB)iFoodItem.getFoodEffect();
                    x.b().mobEffects().forEach(sextuplet -> {
                        MobEffect mobEffect = (MobEffect)sextuplet.getFirst();
                        double firstChance = (Double)sextuplet.getSecond();
                        int firstAddTime = (Integer)sextuplet.getThird();
                        int addLevel = (Integer)sextuplet.getFourth();
                        int secondAddTime = (Integer)sextuplet.getFifth();
                        int newTime = (Integer)sextuplet.getSixth();
                        Quintuple<Double, Integer, Integer, Integer, Integer> key = Quintuple.of(firstChance, firstAddTime, addLevel, secondAddTime, newTime);
                        if (lines.containsKey(key)) {
                            ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                        } else {
                            lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                        }
                    });
                    ArrayList<Sextuplet> list = new ArrayList<Sextuplet>();
                    lines.forEach((quintuple, componentArrayList) -> {
                        double firstChance = (Double)quintuple.getFirst();
                        int firstAddTime = (Integer)quintuple.getSecond();
                        int addLevel = (Integer)quintuple.getThird();
                        int secondAddTime = (Integer)quintuple.getFourth();
                        int newTime = (Integer)quintuple.getFifth();
                        MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0])).m_130940_(ChatFormatting.BLUE);
                        for (int i = 0; i < componentArrayList.size(); ++i) {
                            mutableComponent.m_7220_((Component)componentArrayList.get(i));
                            if (i >= componentArrayList.size() - 1) continue;
                            mutableComponent.m_7220_((Component)Component.m_237113_((String)"/"));
                        }
                        mutableComponent.m_130940_(ChatFormatting.BLUE);
                        list.add(Sextuplet.of(mutableComponent, firstChance, firstAddTime, addLevel, secondAddTime, newTime));
                    });
                    components.addAll(x.tooltip);
                    list.forEach(sextuplet -> {
                        double firstChance = (Double)sextuplet.getSecond();
                        int firstAddTime = (Integer)sextuplet.getThird();
                        int addLevel = (Integer)sextuplet.getFourth();
                        int secondAddTime = (Integer)sextuplet.getFifth();
                        int newTime = (Integer)sextuplet.getSixth();
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_1", (Object[])new Object[]{firstChance, sextuplet.getFirst(), firstAddTime / 20}).m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237115_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_2").m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_3", (Object[])new Object[]{100.0 - firstChance, addLevel, sextuplet.getFirst()}).m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_b_type_give_line_4", (Object[])new Object[]{secondAddTime / 20, newTime / 20}).m_130940_(ChatFormatting.BLUE));
                    });
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"IV"}).m_130940_(ChatFormatting.RED));
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                    break;
                }
                case XC: {
                    FoodEffect.X.XC x = (FoodEffect.X.XC)iFoodItem.getFoodEffect();
                    HashMap<Quad, ArrayList> lines = new HashMap<Quad, ArrayList>();
                    x.c().mobEffects().forEach(sextuplet -> {
                        MobEffect mobEffect = (MobEffect)sextuplet.getFirst();
                        double firstChance = (Double)sextuplet.getSecond();
                        double secondChance = (Double)sextuplet.getThird();
                        int addLevel = (Integer)sextuplet.getFourth();
                        int newTime = (Integer)sextuplet.getFifth();
                        Quad<Double, Double, Integer, Integer> key = Quad.of(firstChance, secondChance, addLevel, newTime);
                        if (lines.containsKey(key)) {
                            ((ArrayList)lines.get(key)).add(Component.m_237115_((String)mobEffect.m_19481_()));
                        } else {
                            lines.put(key, new ArrayList<MutableComponent>(List.of(Component.m_237115_((String)mobEffect.m_19481_()))));
                        }
                    });
                    ArrayList<Quintuple> list = new ArrayList<Quintuple>();
                    lines.forEach((quad, componentArrayList) -> {
                        double firstChance = (Double)quad.getValue1();
                        double secondChance = (Double)quad.getValue2();
                        int addLevel = (Integer)quad.getValue3();
                        int newTime = (Integer)quad.getValue4();
                        MutableComponent mutableComponent = MutableComponent.m_237204_((ComponentContents)new TranslatableContents("", "", new Object[0]));
                        for (int i = 0; i < componentArrayList.size(); ++i) {
                            mutableComponent.m_7220_((Component)componentArrayList.get(i));
                            if (i >= componentArrayList.size() - 1) continue;
                            mutableComponent.m_7220_((Component)Component.m_237113_((String)"/").m_130940_(ChatFormatting.BLUE));
                        }
                        mutableComponent.m_130940_(ChatFormatting.BLUE);
                        list.add(Quintuple.of(mutableComponent, firstChance, secondChance, addLevel, newTime));
                    });
                    list.forEach(sextuplet -> {
                        double firstChance = (Double)sextuplet.getSecond();
                        double secondChance = (Double)sextuplet.getThird();
                        int addLevel = (Integer)sextuplet.getFourth();
                        int newTime = (Integer)sextuplet.getFifth();
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_1", (Object[])new Object[]{firstChance, addLevel, sextuplet.getFirst()}).m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_2", (Object[])new Object[]{secondChance, addLevel, sextuplet.getFirst()}).m_130940_(ChatFormatting.BLUE));
                        components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_c_type_give_line_3", (Object[])new Object[]{newTime / 20}).m_130940_(ChatFormatting.BLUE));
                    });
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.foods_effect_level_limit", (Object[])new Object[]{"VIII"}).m_130940_(ChatFormatting.RED));
                    components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_second", (Object[])new Object[]{this.getFoodEffectType(), this.cooldownTime() / 20}).m_130940_(ChatFormatting.BLUE));
                }
            }
        } else {
            components.add((Component)Component.m_237115_((String)"tips.manors_bounty.fruit_effect_shift_check").m_130940_(ChatFormatting.BLUE));
        }
        if (CapabilityUtils.isInLocalModCooldown(item)) {
            components.add((Component)Component.m_237115_((String)"tips.manors_bounty.fruit_effect_cooldown_0").m_130940_(ChatFormatting.RED));
            components.add((Component)Component.m_237110_((String)"tips.manors_bounty.fruit_effect_cooldown_time_get", (Object[])new Object[]{CapabilityUtils.getLocalModCooldown(item) / 20}).m_130940_(ChatFormatting.BLUE));
        }
        return components;
    }

    default public void addAllFruitEffectsDurationPercent(LivingEntity livingEntity, float percent) {
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.EFFECT_HAUNTING.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.HYPOTHERMIA.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.TRANSMIT.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.WARM_SHIELD.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.LAVENDER_MOOD.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.ROSA_HEDGE.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.RUTIN_LEMONENE.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.BURSTING_BERRY.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.TOUGH_AS_NUT.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.CHERRY_BLOSSOMS_WEEPING.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.BERRY_BLOOD.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.MOMENTARY_METEOR.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.SUMMER_HEATWAVE.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.ORIGINAL_EVOLUTION.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.ORIGINAL_EVOLUTION_METAMORPHOSIS.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.MELON_GRAVITY.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.SEA_TOUCH.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.HACKED_THORNS.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.KIWING_WHEREABOUTS.get(), percent);
        FoodEffect.addEffectTimePercent(livingEntity, (MobEffect)ModMobEffects.LURKING_DANGER.get(), percent);
    }

    default public boolean addAllFruitEffectsDuration(LivingEntity livingEntity, int timeToAdd) {
        return FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.EFFECT_HAUNTING.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.HYPOTHERMIA.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.TRANSMIT.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.WARM_SHIELD.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.LAVENDER_MOOD.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.ROSA_HEDGE.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.RUTIN_LEMONENE.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.BURSTING_BERRY.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.TOUGH_AS_NUT.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.CHERRY_BLOSSOMS_WEEPING.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.BERRY_BLOOD.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.MOMENTARY_METEOR.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.SUMMER_HEATWAVE.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.ORIGINAL_EVOLUTION.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.ORIGINAL_EVOLUTION_METAMORPHOSIS.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.MELON_GRAVITY.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.SEA_TOUCH.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.HACKED_THORNS.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.KIWING_WHEREABOUTS.get(), timeToAdd) || FoodEffect.addEffectTime(livingEntity, (MobEffect)ModMobEffects.LURKING_DANGER.get(), timeToAdd);
    }

    public static void removeAllFruitEffects(LivingEntity livingEntity) {
        livingEntity.m_21195_((MobEffect)ModMobEffects.EFFECT_HAUNTING.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.HYPOTHERMIA.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.TRANSMIT.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.WARM_SHIELD.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.LAVENDER_MOOD.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.ROSA_HEDGE.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.RUTIN_LEMONENE.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.BURSTING_BERRY.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.TOUGH_AS_NUT.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.CHERRY_BLOSSOMS_WEEPING.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.BERRY_BLOOD.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.MOMENTARY_METEOR.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.SUMMER_HEATWAVE.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.ORIGINAL_EVOLUTION.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.ORIGINAL_EVOLUTION_METAMORPHOSIS.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.MELON_GRAVITY.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.SEA_TOUCH.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.HACKED_THORNS.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.KIWING_WHEREABOUTS.get());
        livingEntity.m_21195_((MobEffect)ModMobEffects.LURKING_DANGER.get());
    }
}

